// ------------------------------------
// ---------- jquery.paymentSchedule -----------
// ------------------------------------
// Controls the payment schedule
// ------------------------------------

; (function ($, window, document, undefined) {

    var pluginName = "paymentSchedule";

    function paymentSchedule(element, options) {
        this.element = element;
        this._name = pluginName;
        this._defaults = $.fn.paymentSchedule.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }

    function htmlEncode(value){
        return $("<div/>").text(value).html();
    }

    function htmlDecode(value){
        return $("<div/>").html(value).text();
    }

    $.extend(paymentSchedule.prototype, {

        init: function () {
            this.buildCache();

            this.bindEvents();
        },

        destroy: function () {
            this.unbindEvents();

            this.$element.removeData();
        },

        buildCache: function () {
            this.$element = $(this.element);

            this.$grandTotal = $(this.options.totalId);
            this.$vatTotal = $(this.options.vatTotalId);
            this.$vatTotalContainer = $(this.options.vatTotalContainer);
            this.$cartItems = $(this.options.cartItemSelector);

            var vatTotal = parseFloat(this.$vatTotal.html());

            if (isNaN(vatTotal) === true) {
                this.vatTotal = 0.0;
            }

            if (vatTotal > 0) {
                this.$vatTotalContainer.show();
            } else {
                this.$vatTotalContainer.hide();
            }

            this.calculateTotals();

        },

        bindEvents: function () {
            var plugin = this;

            plugin.$cartItems.on("click", function (event) {
                plugin.calculateTotals();
            });

        },

        calculateTotals: function () {
            var plugin = this;

            var total = 0.0;
            var vatTotal = 0.0;

            plugin.$cartItems.each(function () {

                var $item = $(this);

                if ($item.is(":checked") === false) {
                    return;
                }

                var price = parseInt($item.data("price"));
                var vatPrice = parseFloat($item.data("vat"));

                if (isNaN(price)) {
                    price = 0.0;
                }

                if (isNaN(vatPrice)) {
                    vatPrice = 0.0;
                }

                total += price;
                vatTotal += vatPrice;

            });

            plugin.$grandTotal.html("&pound;" + total.toFixed(2));
            plugin.$vatTotal.html("&pound;" + vatTotal.toFixed(2));

            if (vatTotal > 0) {
                plugin.$vatTotalContainer.show();
            } else {
                plugin.$vatTotalContainer.hide();
            }

        },

        unbindEvents: function () {
            var plugin = this;

            plugin.$cartItems.off("click");
        }

    });

    $.fn.paymentSchedule = function (options) {
        this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new paymentSchedule(this, options));
            }
        });

        return this;
    };

    $.fn.paymentSchedule.defaults = {
        cartItemSelector: "input:checkbox",
        totalId: "#grandTotal",
        vatTotalId: "#vatTotal",
        vatTotalContainer: ".vatTotalText"
    };

})(jQuery, window, document);
