
function renderMapMask(map) {

    var styleFunctionBlackMask = function (feature, resolution) {
        return [
            new ol.style.Style({
                fill: new ol.style.Fill({ color: 'rgba(81,142,156,0.33)' }),
                stroke: new ol.style.Stroke({ color: 'rgba(81,138,156,1)', width: 4 }),
                image: new ol.style.Circle({
                    fill: new ol.style.Fill({ color: 'rgba(81,142,156,0.33)' }),
                    stroke: new ol.style.Stroke({ color: 'rgba(81,138,156,1)', width: 4 }),
                    radius: 4
                })
            })
        ];
    };

    var maskVectorLayerSource = new ol.source.Vector({});

    var maskVectorLayer = new ol.layer.Vector({
        id: "maskVectorLayer",
        source: maskVectorLayerSource,
        style: styleFunctionBlackMask
    });

    $.getJSON("/js/maps/mask.json", function (data) {

        maskVectorLayerSource.addFeatures((new ol.format.GeoJSON()).readFeatures(data));
        maskVectorLayer.getSource().changed();

        map.addLayer(maskVectorLayer);

    });
}