﻿; (function ($, window, document, undefined)
{
	"use strict";

	var $win = $(window),
		$doc = $(document),
		$body = $(document.body);

	var _options = {};

	$.llpgLookup = function ()
	{
		var self = this;
		return self;
	};

	$.llpgLookup.prototype.name = 'llpgLookup';

	$.llpgLookup = {
	    init: init
	};

	$.llpgLookup.reformatPostcode = function (value)
	{
	    var postcodeValue = value.toUpperCase();
	    var result = postcodeValue;

	    postcodeValue = postcodeValue.replace(/\s/g, "");

	    if (postcodeValue.length >= 5 && postcodeValue.length <= 7)
	    {
	        result = postcodeValue.substring(0, postcodeValue.length - 3) + " " + postcodeValue.substring(postcodeValue.length - 3);
	    }

	    return result;
	};

	function init(options)
	{
	    _options = $.extend({}, $.llpgLookup.defaultOptions, options);

	    $("#" + _options.rowId).hide();
	    $("#" + _options.errorMessageId).hide();

	    $(document).on("keypress", "#" + _options.postcodeId, function (args)
	    {
	        if (args.keyCode === 13)
	        {
	            $("#" + _options.buttonId).click();
	            return false;
	        }
	    });

	    $("#" + _options.buttonId).click(function (ev)
		{
		    ev.preventDefault();
		    var row = $("#" + _options.rowId);
		    var button = $("#" + _options.buttonId);
		    var postcode = $("#" + _options.postcodeId);
		    var errorMessage = $("#" + _options.errorMessageId);

		    $(row).hide();
		    $(button).prop("disabled", true);
		    $(postcode).removeClass("ErrorFormField");
		    $(errorMessage).hide();
		    $(postcode).val($.llpgLookup.reformatPostcode($(postcode).val()));

		    $.ajax
            (
                {
                    contentType: "application/json; charset=utf-8",
                    url: "/llpg/lookup",
                    data: { postcode: $(postcode).val(), classification: _options.classification },
                    dataType: "jsonp"
                }
            )
            .done(function (data)
            {
                if (data === null || data.length == 0)
                {
                    $(postcode).addClass("ErrorFormField");
                    $(errorMessage).text(_options.noResultsMessage);
                    $(errorMessage).show();
                    return;
                }

                var selectBox = $("#" + _options.fieldIdentifier);
                var options = selectBox.find("option").remove().end().append('<option value="">Select an address</option>');

                $.each(data, function (i, val)
                {
                    options.append('<option value="' + val.Uprn + '">' + val.AddressLine1 + '</option>');
                });

                $(row).show();
            })
            .fail(function (jqXHR, textStatus, errorThrown)
            {
                $(postcode).addClass("ErrorFormField");
                var msg = (errorThrown === null || errorThrown.length == 0) ? _options.defaultErrorMessage : errorThrown;
                $(errorMessage).text(msg);
                $(errorMessage).show();
            })
            .always(function ()
            {
                $(button).prop("disabled", false);
            });
		});
	}

	$.llpgLookup.defaultOptions = {
	    fieldIdentifier: "",
	    rowId: "",
	    buttonId: "",
	    postcodeId: "",
	    errorMessageId: "",
	    classification: "",
	    callbackUrl: "/llpg/lookup",
	    noResultsMessage: "No results were found, please check the postcode entered",
		defaultErrorMessage: "There was a problem looking up this postcode, please try again later"
	};

})(jQuery, window, document);







