// -----------------------------------------------
// ---------- jquery.wasteServiceLoader ----------
// -----------------------------------------------
// Controls the waste services loading.
// -----------------------------------------------

; (function ($, window, document, undefined) {

    var pluginName = "wasteServiceLoader";

    function wasteServiceLoader(element, options) {
        this.element = element;
        this._name = pluginName;
        this._defaults = $.fn.wasteServiceLoader.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }

    function htmlEncode(value) {
        return $("<div/>").text(value).html();
    }

    function htmlDecode(value) {
        return $("<div/>").html(value).text();
    }

    function isNullOrWhiteSpace(str) {
        if (typeof str === "undefined" ||
            !str ||
            str.length === 0 ||
            !/[^\s]/.test(str) ||
            /^\s*$/.test(str) ||
            str.replace(/\s/g, "") === "") {
            return true;
        } else {
            return false;
        }
    }

    $.extend(wasteServiceLoader.prototype, {

        init: function () {
            this.buildCache();

            this.bindEvents();

            this.loadWasteServices();
        },

        destroy: function () {
            this.unbindEvents();

            this.$element.removeData();
        },

        buildCache: function () {
            this.$element = $(this.element);
            this.$uprnField = $(this.options.uprnFieldId);
            this.uprn = this.$uprnField.val();
        },

        bindEvents: function () {
            var plugin = this;
        },

        unbindEvents: function () {
            var plugin = this;
        },

        loadWasteServices: function () {

            var plugin = this;

            if (isNullOrWhiteSpace(plugin.options.wasteServicesUrl) === true ||
                isNullOrWhiteSpace(plugin.uprn) === true) {
                console.log("An error has occurred loading the waste services");
                return;
            }

            var separator = plugin.options.wasteServicesUrl.endsWith("/") ? "" : "/";

            var url = plugin.options.wasteServicesUrl + separator + plugin.uprn + "/";

            console.log(url);

            $.ajax({
                type: "GET",
                url: url,
                contentType: "application/json; charset=utf-8",
                cache: false,
                success: function (data) {
                    if (data === null) {
                        console.log("An error has occurred loading the waste services");
                        return;
                    }

                    if (typeof data === "undefined") {
                        console.log("An error has occurred loading the waste services");
                        return;
                    }

                    if (data.length === 0) {
                        console.log("No waste services found");
                        return;
                    }

                    // loop through
                    var d = [];

                    var val = plugin.$element.val();

                    plugin.$element.empty();

                    $.each(data, function (i, item) {
                        plugin.$element.append($("<option />").val(item.ServiceName).text(item.ServiceName));
                    });

                    plugin.$element.val(val);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log("A problem prevented the waste services from being loaded: " + textStatus);
                }
            });
        }

    });

    $.fn.wasteServiceLoader = function (options) {
        this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new wasteServiceLoader(this, options));
            }
        });

        return this;
    };

    $.fn.wasteServiceLoader.defaults = {
        wasteServicesUrl: "/wasteservices/getaddressservices/",
        uprnFieldId: null
    };

})(jQuery, window, document);
