$(document).ready(function ()
{
    $("a:not([href^='#'],[href^='/'],[href^='?'],[href^='javascript'],[href*='southwark.gov.uk'],[href*='readspeaker.com'],[href*='govmetric.com'])").click(function (e)
    {
        e.preventDefault();
        var vbScheme = document.getElementById("VBScheme").value;
        var vbHostName = document.getElementById("VBHostName").value;
        var vbDisableExternalLinkModal = document.getElementById("VBDisableExternalLinkModal").value;
        var element = $(this);
        createExternalLinkModal(element, vbScheme, vbHostName, vbDisableExternalLinkModal);
    });
});

function createExternalLinkModal(element, scheme, hostName, disableExternalLinkModal) {
    var href = element.attr("href");
    var target = element.attr("target");

    if (href === null || typeof href === "undefined") {
        return;
    }

    var title = element.attr("title");
    title = title === null || typeof title === "undefined" ? "(Opens in a new window)" : title;
    element.attr("title", title);
    element.attr("rel", "external");
    checkExternalLink(scheme, hostName, href, target, disableExternalLinkModal);
    return false;
}

function checkExternalLink(scheme, hostName, link, target, bypass) {

    if (bypass.indexOf("true") > -1)
    {
        window.open(link, target);
        return;
    }

    var url = link;
    if (url.charAt(0) === "/")
    {
        window.location.href = url;
        return;
    }

    var protocol = url.search("://");
    if (protocol > -1)
    {
        var domain = url.split("://");
        url = domain[1];
    }

    var subdomain = url.search("/");
    if (subdomain > -1)
    {
        var domain = url.split("/");
        url = domain[0];
    }

    var overrideUrl = scheme + hostName + "/elo/" + url;
    var permittedUrl = scheme + hostName + "/elw/" + url;

    $.ajax(
    {
        url: permittedUrl,
        type: "GET",
        success: function success(data)
        {
            if (data.indexOf("true") > -1)
            {
                window.open(link, target);
            }
            else
            {
                $("#ExternalLinkModalTitle").text(document.getElementById("VBTitleMessage").value);
                $("#ExternalLinkModalMsg1").text(document.getElementById("VBTextAMessage").value);
                $("#ExternalLinkModalMsg2").text(document.getElementById("VBTextBMessage").value);

                $.ajax(
                {
                    url: overrideUrl,
                    type: "GET",
                    success: function success(data)
                    {
                        data = JSON.parse(data);
                        if (!(data.Title.indexOf("#") > -1))
                        {
                            $("#ExternalLinkModalTitle").text(data.Title);
                            $("#ExternalLinkModalMsg1").text(data.Message1);
                            $("#ExternalLinkModalMsg2").text(data.Message2);
                        }
                    },
                    error: function error(request, status, _error)
                    {
                        var eMsg = request.status + ": " + request.statusText;
                        console.log(eMsg);
                    },
                });

                $("#ExternalLinkModalUrlLeaving").attr("href", link);
                $("#ExternalLinkModalUrlLeaving").attr("target", target);

                var popup = new Foundation.Reveal($("#ExternalLinkModal"));
                popup.open();
            }

        },
        error: function error(request, status, _error2) {
            var eMsg = request.status + ": " + request.statusText;
            console.log(eMsg);
            $("#ExternalLinkModalUrlLeaving").attr("href", link);
            var popup = new Foundation.Reveal($("#ExternalLinkModal"));
            popup.open();
        }

    });

    return false;
}
