// --------------------------------------------
// ------ jquery.dynamicFormTable -------------
// --------------------------------------------
// Manages the editor for a dynamic form table
// --------------------------------------------
; (function ($, window, document, undefined) {

    var pluginName = "dynamicFormTable";

    function dynamicFormTable(element, options) {
        this.element = element;

        this._name = pluginName;
        this._defaults = $.fn.dynamicFormTable.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.rowCount = 1;

        this.init();
    }

    function isNullOrUndefined(variable) {

        if (typeof variable === "undefined" || variable === null) {
            return true;
        }

        return false;
    }

    function isNullOrWhiteSpace(str) {
        if (typeof str === "undefined" ||
            !str ||
            str.length === 0 ||
            !/[^\s]/.test(str) ||
            /^\s*$/.test(str) ||
            str.replace(/\s/g, "") === "") {
            return true;
        } else {
            return false;
        }
    }

    $.extend(dynamicFormTable.prototype, {

        init: function () {

            this.buildCache();

            this.bindEvents();
        },

        destroy: function () {
            this.unbindEvents();

            this.$element.removeData();

            this.$element = null;

        },

        buildCache: function () {
            var plugin = this;

            plugin.$element = $(plugin.element);

            plugin.$tableBody = plugin.$element.find("tbody");

            plugin.$addRowBtn = plugin.$element.find(plugin.options.addNewRowBtnSelector);

        },

        bindEvents: function () {

            var plugin = this;

            plugin.$addRowBtn.on("click", function (event) {
                event.stopPropagation();
                event.preventDefault();

                plugin.addRow();

            });

            // Cheat need to fix
            $("a.removeRow").on("click", function (event) {
                event.stopPropagation();
                event.preventDefault();

                var $parentTr = $(this).closest("tr");

                if ($parentTr.length === 1 && plugin.rowCount > 1) {
                    plugin.deleteRow($parentTr);
                }

            });

        },

        unbindEvents: function () {
            var plugin = this;

            plugin.$addRowBtn.off("click");

            plugin.$removeRowBtns.off("click");
        },

        addRow: function () {

            var plugin = this;

            var $firstRow = plugin.$tableBody.find("tr:first");

            if ($firstRow.length === 0) {
                return;
            }

            var $clone = $firstRow.clone();

            $clone.find(":text").val("");

            plugin.$tableBody.append($clone);

            plugin.rowCount++;

            // Cheat need to fix
            $clone.find("a.removeRow").on("click", function (event) {
                event.stopPropagation();
                event.preventDefault();

                var $parentTr = $(this).closest("tr");

                if ($parentTr.length === 1 && plugin.rowCount > 1) {
                    plugin.deleteRow($parentTr);
                }

            });
        },

        deleteRow: function($row) {

            var plugin = this;

            if (plugin.rowCount <= 1) {
                return;
            }

            $row.remove();

            plugin.rowCount--;

            // Should re-cal the fields
        }

    });

    $.fn.dynamicFormTable = function (options) {

        var instance = $.data(this, "plugin_" + pluginName);

        this.each(function () {
            if (isNullOrUndefined(instance)) {
                instance = $.data(this, "plugin_" + pluginName, new dynamicFormTable(this, options));
            }
        });

        return instance;
    };

    $.fn.dynamicFormTable.defaults = {
        addNewRowBtnSelector: ".cloneRow",
        deleteRowSelector: ".removeRow"
    };

})(jQuery, window, document);
