; (function ($, window, document, undefined) {

    function highlightElement(selector) {

        var $elem = $(selector).css("border", "2px dotted #ffff00");

        console.log($elem.length);

        if ($elem.length === 0) {
            console.log('elm not found');
        } else if ($elem.length > 1) {
            console.log('elm more than one');
        } else {
            $('html, body').stop().animate({
                scrollTop: $elem.offset().top
            }, 1000);
        }
    };

    function runAxe(callbackFunc, errCallbackFunc) {

        axe.run(document, function (err, results) {
            if (err) {
                console.log("Error: " + err);

                errCallbackFunc(err);
            }
            else {
                console.log(results);

                callbackFunc(results);
            }
        });
    }

    function runAxeOnArticle(callbackFunc, errCallbackFunc) {

        axe.run({
            include: [['#article']]
        }, function (err, results) {
            if (err) {
                console.log("Error: " + err);

                errCallbackFunc(err);
            }
            else {
                console.log(results);

                callbackFunc(results);
            }
        });
    }

});